Attribute VB_Name = "Module1"
Public isMaxIm As Boolean
'Public myImgArray() As Single, myOrigArray() As Single, myTempArray() As Single
Public myImgArray, myOrigArray, myTempArray
Public saveOK
Public imgHeight
Public imgWidth
Public myDoc As Object
Public Img As Object
Public RegistryKeyName
Public registeredUser
Public pointIndex
Public previewScale As Integer
Public isColor
Public errMsg
Public LoginSucceeded

' Public Img As CCDSoftLib.Image

Private Const SW_HIDE = 0
Private Const SW_SHOWNORMAL = 1
Private Const SW_SHOWMINIMIZED = 2
Private Const SW_SHOWMAXIMIZED = 3
Public Const ERR_PIXEL_SATURATED = 1

Private Declare Function ShellExecute Lib "shell32" Alias "ShellExecuteA" ( _
                ByVal hWnd As Long, _
                ByVal lpOperation As String, _
                ByVal lpFile As String, _
                ByVal lpParameters As String, _
                ByVal lpDirectory As String, _
                ByVal nShowCmd As Long) As Long

Public Sub MaxImSave()
    On Error GoTo errHandler
    errMsg = "MaxImSave()"
    Dim myDocBogus
    If saveOK Then
        frmUI.lblStatus = "Saving changes (MaxIm DL)..."
        DoEvents
        myDocBogus = myDoc.DirectMono
        myDoc.ImageArray = myImgArray
        myDoc.Modified = True
        ' Perform auto contrast adjustment.
        myDoc.StretchMode = 1
        frmUI.lblStatus = "Changes saved (MaxIm DL)"
        DoEvents
    Else
        frmUI.lblStatus = "Error - Changes not saved."
        DoEvents
    End If
    Exit Sub

errHandler:
    Command2.Enabled = True
    Command3.Enabled = True
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Public Sub CCDSoftSave()
    On Error GoTo errHandler
    errMsg = "CCDSoftSave()"
    If saveOK Then
        frmUI.lblStatus = "Saving changes (CCDSoft)..."
        DoEvents
        Img.DataArray = myImgArray
        Img.ModifiedFlag = True
        ' Perform auto contrast adjustment.
        Img.AutoContrast 2, 1, 5
        frmUI.lblStatus = "Changes saved (CCDSoft)"
        DoEvents
    Else
        frmUI.lblStatus = "Changes not saved."
        DoEvents
    End If
    Exit Sub

errHandler:
    Command2.Enabled = True
    Command3.Enabled = True
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Public Sub makeColorFlat()
    Dim myPrivateArray
    Dim mySavePath, mySavePathRef, mySaveLatest, myPath
    Dim fs, OK2Process As Boolean
    
    On Error GoTo errHandler
    'On Error GoTo 0
    myPrivateArray = myImgArray
    
        ' ===================================================================================================
        ' Normalize the color data.
        ' Calculate normalization factors.
        Dim pixelTotal(5) As Long
        Dim pixelAvg(5) As Long
        Dim pixelFactor(5)
        Dim i, j, maxX, maxY, numGrids, originX, originY, referenceAvg
        
        ' Initialize total array.
        frmUI.lblStatus.Caption = "Initializing..."
        DoEvents
        For i = 1 To 4
            pixelTotal(i) = 0
        Next i
        ' Normalize using a simple average based on 10 2x2 grids.
        errMsg = "Get number of grids."
        numGrids = CInt(GetSetting("NewAstro Color Flat Maker", "resume", "txtNumGrids", "10"))
        errMsg = "Getting X and Y coordinates for top left of sample grids."
        originX = CLng(GetSetting("NewAstro Color Flat Maker", "resume", "txtOriginX", "100"))
        originY = CLng(GetSetting("NewAstro Color Flat Maker", "resume", "txtOriginY", "100"))
        errMsg = "Looking at " & numGrids & " 2x2 squares to get averaged values."
        frmUI.lblStatus.Caption = "Getting correction factors..."
        For i = 0 To (numGrids * 2 - 2) Step 2
            DoEvents
            pixelTotal(1) = pixelTotal(1) + myPrivateArray(originX + i, originY + i)
            pixelTotal(2) = pixelTotal(2) + myPrivateArray(originX + 1 + i, originY + i)
            pixelTotal(3) = pixelTotal(3) + myPrivateArray(originX + i, originY + 1 + i)
            pixelTotal(4) = pixelTotal(4) + myPrivateArray(originX + 1 + i, originY + 1 + i)
        Next i
        errMsg = "Calculating averages."
        For i = 1 To 4
            pixelAvg(i) = pixelTotal(i) / 10
        Next i
        AvgLimit = CLng(GetSetting("NewAstro Color Flat Maker", "resume", "txtAvgLimit", "50000"))
        If pixelAvg(1) > AvgLimit Then
            Err.Raise ERR_PIXEL_SATURATED, "ColorFlat", "The upper left pixel average in the sample grid is too bright - cannot normalize."
            OK2Process = False
        End If
        If pixelAvg(2) > AvgLimit Then
            Err.Raise ERR_PIXEL_SATURATED, "ColorFlat", "The upper right pixel average in the sample grid is too bright - cannot normalize."
            OK2Process = False
        End If
        If pixelAvg(3) > AvgLimit Then
            Err.Raise ERR_PIXEL_SATURATED, "ColorFlat", "The lower left pixel average in the sample grid is too bright - cannot normalize."
            OK2Process = False
        End If
        If pixelAvg(4) > AvgLimit Then
            Err.Raise ERR_PIXEL_SATURATED, "ColorFlat", "The lower right pixel average in the sample grid is too bright - cannot normalize."
            OK2Process = False
        End If
        If pixelAvg(1) <= 0 Or pixelAvg(2) <= 0 Or pixelAvg(3) <= 0 Or pixelAvg(4) <= 0 Then
            errMsg = "Invalid average(s) - zero or less."
            For i = 1 To 4
                pixelFactor(i) = 1#
            Next i
            'OK2Process = False
            'MsgBox "Not OK to process."
            errMsg = "One or more zero values for pixel averages."
        Else
            errMsg = "Calculating factors."
            referenceAvg = CInt(GetSetting("NewAstro Color Flat Maker", "resume", "cmbRefAvg", "2"))
            'pixelFactor(referenceAvg) = pixelAvg(referenceAvg) / pixelAvg(referenceAvg)
            For i = 1 To 4
                If i = referenceAvg Then
                    pixelFactor(i) = 1#
                Else
                    pixelFactor(i) = pixelAvg(i) / pixelAvg(referenceAvg)
                End If
            Next i
            'MsgBox "OK to process."
            errMsg = "No zero values for pixel averages."
        End If
        ' ===================================================================================================
        ' Perform normalization.
        errMsg = "Get array bounds: first."
        maxX = UBound(myPrivateArray, 1)
        'MsgBox maxX
        errMsg = "Get array bounds: second."
        maxY = UBound(myPrivateArray, 2)
        errMsg = "Normalzing..."
        For i = 0 To maxX Step 2
            For j = 0 To maxY Step 2
                errMsg = "Normalizing column " & i
                If i Mod 10 = 0 Then
                    frmUI.lblStatus.Caption = "Normalizing column " & i
                End If
                DoEvents
                myPrivateArray(i, j) = myPrivateArray(i, j) / pixelFactor(1)
                myPrivateArray(i + 1, j) = myPrivateArray(i + 1, j) / pixelFactor(2)
                myPrivateArray(i, j + 1) = myPrivateArray(i, j + 1) / pixelFactor(3)
                myPrivateArray(i + 1, j + 1) = myPrivateArray(i + 1, j + 1) / pixelFactor(4)
            Next j
        Next i
        ' ===================================================================================================
        ' Passing results of processing (array contents) to the original array.
        errMsg = "Copying local array to original array."
        myImgArray = myPrivateArray
    
    saveOK = True
    errMsg = "Saving results."
    If isMaxIm Then
        errMsg = "Saving results in MaxIm DL."
        frmUI.lblStatus = "Save changes (MaxIm DL)"
        DoEvents
        MaxImSave
    Else
        errMsg = "Saving results in CCDSoft."
        frmUI.lblStatus = "Save changes (CCDSoft)"
        DoEvents
        CCDSoftSave
    End If
    On Error GoTo 0
    Exit Sub

errHandler:
    frmUI.Command2.Enabled = True
    frmUI.Command3.Enabled = True
    Err.Raise Err.Number, "colorFlat", Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub

End Sub

Public Sub ShowWebpage(path As String)
    Dim z As Long

    z = ShellExecute(0, "Open", path, 0, 0, SW_SHOWNORMAL)
    If (z > 0) And (z <= 32) Then
        MsgBox _
            "It doesn't appear that you have a web browser installed " & _
            "on your system.", (vbOKOnly + vbExclamation + vbMsgBoxSetForeground), "NewAstro Color Flat Maker Plug-In"
        Exit Sub
    End If

End Sub

Public Sub saveRegSettings()
    On Error GoTo errHandler
    errMsg = "saveRegSettings()"
    'SaveSetting "NewAstro Color Flat Maker", "resume", "txtIntensity", frmUI.txtIntensity.Text
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Public Sub getRegSettings()
    Dim myPreviewScale
    
    On Error GoTo errHandler
    errMsg = "getRegSettings()"
    'frmUI.txtIntensity.Text = GetSetting("NewAstro Color Flat Maker", "resume", "txtIntensity", "1")
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

