Attribute VB_Name = "Module1"
Public myDoc

Public Sub scanForBlooming(bloomLimit As Double, bloomSlope As Double, starSize As Double, starLimit As Double, iter As Integer)
  Dim myKeeper, uLimitX, uLimitY, myBloomArray() As Single
  frmMsg.lblTitle.Caption = "Bloom Removal"
  frmMsg.centerMsg
  frmMsg.txtMsg.Text = "Setting up bloom removal..." & vbCrLf
  frmMsg.progressBar.X2 = frmMsg.progressBar.X1
  frmMsg.Show 1
  DoEvents
  progressBarLength = 5500 - 160
  For X = 1 To iter
    myArray = myDoc.imageArray
    uLimitX = UBound(myArray, 1)
    uLimitY = UBound(myArray, 2)
    hasBlooms = False
    frmMsg.progressBar.X2 = frmMsg.progressBar.X1
    DoEvents
    ReDim myBloomArray(uLimitX, uLimitY)
    progressBarIncrement = (progressBarLength / uLimitX) / 4
    For i = 0 To uLimitX
        For j = 0 To uLimitY
            myBloomArray(i, j) = 0
        Next j
        frmMsg.progressBar.X2 = progressBarIncrement * i
        DoEvents
    Next i
    frmMsg.txtMsg.Text = frmMsg.txtMsg.Text & "Pass " & X & vbCrLf
    frmMsg.txtMsg.SelStart = Len(frmMsg.txtMsg.Text)
    DoEvents
    bloomCounter = 0
    progressBarIncrement = (progressBarLength / uLimitX) / 4
    frmMsg.progressBar.X2 = frmMsg.progressBar.X1
    For i = 0 To uLimitX
        For j = 0 To uLimitY
            If myArray(i, j) >= bloomLimit Then
                ' Pixel is above bloom limit.
                If myArray(i, j) - myArray(i, j - 1) > bloomSlope Then
                    ' This could be a real bloom. Find length.
                    myOffset = 0
                    While myArray(i, j + myOffset) > bloomLimit
                        myOffset = myOffset + 1
                    Wend
                    ' Check slope on other side of bloom.
                        If myOffset > (starSize * 0.7) + (CDbl(frmBloomRemoval.txtBloomIncrement.Text) * (X - 1)) Then
                            ' OK, this is really a bloom.
                            hasBlooms = True
                            For k = j - 1 To j + myOffset
                                myBloomArray(i, k) = 65000
                            Next k
                            j = k
                            bloomCounter = bloomCounter + 1
                        End If
                End If
            End If
        Next j
        frmMsg.progressBar.X2 = (progressBarLength / 4) + (progressBarIncrement * i)
        DoEvents
    Next i
    frmMsg.txtMsg.Text = frmMsg.txtMsg.Text & "Found " & bloomCounter & " columns with blooms." & vbCrLf
    frmMsg.txtMsg.Text = frmMsg.txtMsg.Text & "Finding stars..." & vbCrLf
    frmMsg.txtMsg.SelStart = Len(frmMsg.txtMsg.Text)
    DoEvents
    ' Remove stars from bloom data.
    progressBarIncrement = (progressBarLength / uLimitY) / 4
    frmMsg.progressBar.X2 = frmMsg.progressBar.X1
    For i = 0 To uLimitY
        For j = 0 To uLimitX
            If myArray(j, i) >= starLimit Then
                myOffset = 0
                While myArray(j + myOffset, i) >= starLimit
                    myOffset = myOffset + 1
                Wend
                If myOffset >= (starSize * 1.5) + (CDbl(frmBloomRemoval.txtBloomIncrement.Text) * (X - 1)) And myOffset > 4 Then
                    For k = j + 2 To j + myOffset - 2
                        myBloomArray(k, i) = 10000
                    Next k
                    j = k
                End If
            End If
        Next j
        DoEvents
        frmMsg.progressBar.X2 = (progressBarLength / 2) + (progressBarIncrement * i)
    Next i
    
    
    ' Fill in bloomed area with average values.
    frmMsg.txtMsg.Text = frmMsg.txtMsg.Text & "Fixing bloomed areas..." & vbCrLf
    frmMsg.txtMsg.SelStart = Len(frmMsg.txtMsg.Text)
    DoEvents
    progressBarIncrement = (progressBarLength / uLimitY) / 4
    frmMsg.progressBar.X2 = frmMsg.progressBar.X1
    For i = 0 To uLimitY
        For j = 0 To uLimitX
            If myBloomArray(j, i) = 65000 Then
                myOffset = 0
                While myBloomArray(j + myOffset, i) > 60000
                    myOffset = myOffset + 1
                Wend
                ' Get values on either side of bloom.
                leftPixel1 = myArray(j - 1, i)
                Y = 2
                While leftPixel1 > bloomLimit
                    leftPixel1 = myArray(j - Y, i)
                    Y = Y + 1
                    If Y > 25 Then
                        leftPixel1 = bloomLimit - 1000
                    End If
                Wend
                leftPixel2 = myArray(j - 1, i - 1)
                Y = 2
                While leftPixel2 > bloomLimit
                    leftPixel2 = myArray(j - Y, i - 1)
                    Y = Y + 1
                    If Y > 25 Then
                        leftPixel2 = bloomLimit - 1000
                    End If
                Wend
                leftPixel3 = myArray(j - 1, i + 1)
                Y = 2
                While leftPixel3 > bloomLimit
                    leftPixel3 = myArray(j - Y, i + 1)
                    Y = Y + 1
                    If Y > 25 Then
                        leftPixel3 = bloomLimit - 1000
                    End If
                Wend
                
                If leftPixel1 < leftPixel2 Then
                    If leftPixel2 < leftPixel3 Then
                        leftMedian = leftPixel2
                    Else
                        If leftPixel1 < leftPixel3 Then
                            leftMedian = leftPixel3
                        Else
                            leftMedian = leftPixel1
                        End If
                    End If
                Else
                    If leftPixel1 < leftPixel3 Then
                        leftMedian = leftPixel1
                    Else
                        If leftPixel2 < leftPixel3 Then
                            leftMedian = leftPixel3
                        Else
                            leftMedian = leftPixel2
                        End If
                    End If
                End If
                leftValue = leftMedian
                
                rightPixel1 = myArray(j + myOffset + 1, i)
                Y = 2
                While rightPixel1 > bloomLimit
                    rightPixel1 = myArray(j + myOffset + Y, i)
                    Y = Y + 1
                    If Y > 25 Then
                        rightPixel1 = bloomLimit - 1000
                    End If
                Wend
                rightPixel2 = myArray(j + myOffset + 1, i - 1)
                Y = 2
                While rightPixel2 > bloomLimit
                    rightPixel2 = myArray(j + myOffset + Y, i - 1)
                    Y = Y + 1
                    If Y > 25 Then
                        rightPixel2 = bloomLimit - 1000
                    End If
                Wend
                rightPixel3 = myArray(j + myOffset + 1, i + 1)
                Y = 2
                While rightPixel3 > bloomLimit
                    rightPixel3 = myArray(j + myOffset + Y, i + 1)
                    Y = Y + 1
                    If Y > 25 Then
                        rightPixel3 = bloomLimit - 1000
                    End If
                Wend
                
                If rightPixel1 < rightPixel2 Then
                    If rightPixel2 < rightPixel3 Then
                        rightMedian = rightPixel2
                    Else
                        If rightPixel1 < rightPixel3 Then
                            rightMedian = rightPixel3
                        Else
                            rightMedian = rightPixel1
                        End If
                    End If
                Else
                    If rightPixel1 < rightPixel3 Then
                        righttMedian = rightPixel1
                    Else
                        If rightPixel2 < rightPixel3 Then
                            rightMedian = rightPixel3
                        Else
                            rightMedian = rightPixel2
                        End If
                    End If
                End If
                'rightValue = rightMedian
                
                For k = j To j + myOffset
                    myArray(k, i) = ((rightValue * (k - j)) + (leftValue * (myOffset - (k - j)))) / myOffset
                Next k
                j = k
            End If
        Next j
        DoEvents
        frmMsg.progressBar.X2 = ((progressBarLength * 3) / 4) + (progressBarIncrement * i)
        DoEvents
    Next i
    If hasBlooms Then
        If frmBloomRemoval.chkBloomImage.Value = 1 Then
            frmMsg.txtMsg.Text = frmMsg.txtMsg.Text & "Creating map..." & vbCrLf
            frmMsg.txtMsg.SelStart = Len(frmMsg.txtMsg.Text)
            DoEvents
            Set newDoc = CreateObject("MaxIm.Document")
            newDoc.XSize = uLimitX + 1
            newDoc.YSize = uLimitY + 1
            newDoc.imageArray = myBloomArray
            newDoc.DisplayName = "Map_of_bloomed_pixels.fit"
        End If
        frmMsg.txtMsg.Text = frmMsg.txtMsg.Text & "Resetting image..." & vbCrLf
        frmMsg.txtMsg.SelStart = Len(frmMsg.txtMsg.Text)
        DoEvents
        ' Fix blooms.
        myDoc.imageArray = myArray
    End If
  Next X
  frmMsg.txtMsg.Text = frmMsg.txtMsg.Text & vbCrLf & "Done."
  frmMsg.txtMsg.SelStart = Len(frmMsg.txtMsg.Text)
  frmMsg.Hide
End Sub

