VERSION 5.00
Begin VB.Form frmBloomRemoval 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Bloom Removal Options"
   ClientHeight    =   5835
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4890
   ControlBox      =   0   'False
   Icon            =   "frmBloomRemoval.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5835
   ScaleWidth      =   4890
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command6 
      BackColor       =   &H00C0C0C0&
      Caption         =   "<<"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   11940
      TabIndex        =   24
      Top             =   480
      Width           =   1035
   End
   Begin VB.CommandButton Command5 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Analyze >>"
      Height          =   255
      Left            =   180
      TabIndex        =   23
      Top             =   3180
      Width           =   1035
   End
   Begin VB.CommandButton Command4 
      BackColor       =   &H00C0C0C0&
      Caption         =   "More options"
      Height          =   495
      Left            =   1320
      TabIndex        =   21
      Top             =   3600
      Width           =   1215
   End
   Begin VB.CheckBox chkAuto 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Automatic limits"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   180
      TabIndex        =   20
      Top             =   2820
      Value           =   1  'Checked
      Width           =   1935
   End
   Begin VB.CheckBox chkFuzzy 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Fuzzy fill active"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   180
      TabIndex        =   19
      ToolTipText     =   "When checked, will soften the edges of blooms. Helps keep stars round."
      Top             =   2520
      Value           =   1  'Checked
      Width           =   1935
   End
   Begin VB.CommandButton Command3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Reset"
      Height          =   255
      Left            =   4020
      TabIndex        =   18
      Top             =   3180
      Width           =   675
   End
   Begin VB.CheckBox chkFixTopBottom 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Star rounding active"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   180
      TabIndex        =   17
      ToolTipText     =   $"frmBloomRemoval.frx":08CA
      Top             =   2220
      Value           =   1  'Checked
      Width           =   1935
   End
   Begin VB.TextBox txtMsg 
      BackColor       =   &H00C0C0C0&
      Height          =   1215
      Left            =   180
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   16
      ToolTipText     =   "Status messages appear here."
      Top             =   4320
      Width           =   4515
   End
   Begin VB.TextBox txtNoiseFactor 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   4020
      TabIndex        =   14
      Text            =   "10"
      ToolTipText     =   "Adjust this to match the noise level of the fill data. Values of 10 (low noise) to 35 (noisy) are typical."
      Top             =   2760
      Width           =   675
   End
   Begin VB.CommandButton Command2 
      BackColor       =   &H00C0C0C0&
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   495
      Left            =   180
      TabIndex        =   12
      Top             =   3600
      Width           =   1035
   End
   Begin VB.CheckBox chkDoAll 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Apply to all images"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   180
      TabIndex        =   10
      ToolTipText     =   "When checked, all open images will be debloomed. Drag rectangles are disabled when this is active."
      Top             =   1920
      Width           =   1935
   End
   Begin VB.TextBox txtBloomIterations 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   4020
      TabIndex        =   7
      Text            =   "1"
      ToolTipText     =   "Number of times to apply deBlooming."
      Top             =   2340
      Width           =   675
   End
   Begin VB.TextBox txtStarLimit 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   4020
      TabIndex        =   6
      Text            =   "8000"
      ToolTipText     =   $"frmBloomRemoval.frx":0958
      Top             =   1500
      Width           =   675
   End
   Begin VB.TextBox txtFillDistance 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   4020
      TabIndex        =   5
      Text            =   "1"
      ToolTipText     =   "Defines how far from the bloom to apply softening. Larger numbers better preserve round stars. Values of 3-8 are typical."
      Top             =   1920
      Width           =   675
   End
   Begin VB.TextBox txtBloomLimit 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   4020
      TabIndex        =   2
      Text            =   "55000"
      ToolTipText     =   $"frmBloomRemoval.frx":0A34
      Top             =   1080
      Width           =   675
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "DeBloom"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3540
      TabIndex        =   0
      Top             =   3600
      Width           =   1155
   End
   Begin VB.Label lblMsg 
      BackColor       =   &H00C0C0C0&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   1320
      TabIndex        =   26
      Top             =   3180
      Width           =   2535
   End
   Begin VB.Label Label4 
      BackColor       =   &H00C0C0C0&
      Caption         =   "http://www.neawstro.com"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1860
      TabIndex        =   25
      Top             =   600
      Width           =   2295
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0C0C0&
      Height          =   315
      Left            =   5160
      TabIndex        =   22
      Top             =   120
      Width           =   7815
   End
   Begin VB.Line progressBar 
      BorderColor     =   &H00C00000&
      BorderWidth     =   8
      Visible         =   0   'False
      X1              =   120
      X2              =   135
      Y1              =   5685
      Y2              =   5685
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Noise factor"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   2820
      TabIndex        =   15
      Top             =   2760
      Width           =   1095
   End
   Begin VB.Image Image1 
      Height          =   960
      Left            =   240
      MousePointer    =   10  'Up Arrow
      Picture         =   "frmBloomRemoval.frx":0AC2
      Stretch         =   -1  'True
      Top             =   120
      Width           =   900
   End
   Begin VB.Line Line1 
      X1              =   1800
      X2              =   4800
      Y1              =   540
      Y2              =   540
   End
   Begin VB.Label lblVersion 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Version 1.0.0"
      Height          =   195
      Left            =   3360
      TabIndex        =   11
      Top             =   240
      Width           =   1335
   End
   Begin VB.Label Label20 
      BackColor       =   &H00C0C0C0&
      Caption         =   "DeBloomer"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   315
      Left            =   1860
      MousePointer    =   10  'Up Arrow
      TabIndex        =   9
      Top             =   180
      Width           =   1395
   End
   Begin VB.Label Label18 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Iterations"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   3000
      TabIndex        =   8
      Top             =   2340
      Width           =   915
   End
   Begin VB.Label Label17 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Star limit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   3060
      MousePointer    =   10  'Up Arrow
      TabIndex        =   4
      ToolTipText     =   "Click to get a suggested value for this term."
      Top             =   1500
      Width           =   855
   End
   Begin VB.Label Label15 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Fuzzy distance"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   2700
      TabIndex        =   3
      Top             =   1920
      Width           =   1215
   End
   Begin VB.Label Label14 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Blooming limit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   2640
      MousePointer    =   10  'Up Arrow
      TabIndex        =   1
      ToolTipText     =   "Click to get a suggested value for this term."
      Top             =   1080
      Width           =   1275
   End
   Begin VB.Label Label2 
      BackColor       =   &H00000000&
      Caption         =   "Label2"
      Height          =   960
      Left            =   285
      TabIndex        =   13
      Top             =   165
      Width           =   900
   End
End
Attribute VB_Name = "frmBloomRemoval"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Public Sub chkAuto_Click()
    If chkAuto.Value = 1 Then
        frmBloomRemoval.txtBloomLimit.Enabled = False
        frmBloomRemoval.txtStarLimit.Enabled = False
    Else
        frmBloomRemoval.txtBloomLimit.Enabled = True
        frmBloomRemoval.txtStarLimit.Enabled = True
    End If
End Sub

Private Sub cmdRegister_Click()
    frmLogin.Show 1
End Sub

Private Sub Command1_Click()
    frmBloomRemoval.MousePointer = 11
    deBloomValid = True
    checkNumeric txtBloomLimit, Label14
    checkNumeric txtStarLimit, Label17
    checkNumeric txtFillDistance, Label15
    checkNumeric txtBloomIterations, Label18
    checkNumeric txtNoiseFactor, Label3
    If Not deBloomValid Then
        Exit Sub
    End If
    saveSettings
    Command1.Enabled = False
    Command4.Enabled = False
    Set msgForm = frmBloomRemoval
    If frmBloomRemoval.chkDoAll.Value = 1 Then
        showDialogs = False
    Else
        showDialogs = True
    End If
    fixAllBlooms
    msgForm.progressBar.Visible = False
    Command1.Enabled = True
    Command4.Enabled = True
    frmBloomRemoval.MousePointer = 0
    saveSettings
    Me.Hide
End Sub

Public Sub checkNumeric(myControl As Control, myLabel As Control)
    If Not IsNumeric(myControl.Text) Then
        MsgBox myLabel.Caption & " contains non-numeric characters; cannot proceed."
        deBloomValid = False
    End If
End Sub

Private Sub Command2_Click()
    Label1.Caption = ""
    frmBloomRemoval.Width = 4995
    savePositions
    deBloomValid = False
    DoEvents
    If Command1.Enabled Then
        frmBloomRemoval.Hide
    Else
        ' Wait for operation to complete before hiding.
    End If
End Sub

Private Sub Command3_Click()
    On Error GoTo errHandler
    DeleteSetting "New Astro DeBloomer", "Resume"
    On Error GoTo 0
    getSettings
    Exit Sub
    
errHandler:
    Resume Next
End Sub

Private Sub Command4_Click()
    frmOptions.Show 1
End Sub

Private Sub Command5_Click()
    Dim myArray, ulimitX, uLimitY, myAdder As Double, i, j, tmpValue, highCount, changeRate
    Dim myBackgroundTotal, myBackgroundCtr, highValue, retValue, currentXValue, currentYValue
    Dim myHistArray(66000), highChangeRate, lowChangeRate, myCtr, highChangeLocation, lowChangeLocation
    
    On Error GoTo errHandler
    deBloomValid = True
    errMsg = "Getting document info from MaxIm DL."
    myArray = myDoc.ImageArray
    ulimitX = UBound(myArray, 1)
    uLimitY = UBound(myArray, 2)
    frmBloomRemoval.txtMsg.Text = "Scanning image: " & myDoc.DisplayName & vbCrLf
    frmBloomRemoval.txtMsg.SelStart = Len(frmBloomRemoval.txtMsg.Text)
    DoEvents
    ' Scan and create histogram.
    For i = 0 To uLimitY Step 2
        errMsg = "Scanning document to build histogram at column " & i
        If Not deBloomValid Then
            Exit For
        End If
        For j = 0 To ulimitX Step 2
            If myArray(j, i) < UBound(myHistArray) Then
                myHistArray(myArray(j, i)) = myHistArray(myArray(j, i)) + 1
            End If
        Next j
        DoEvents
    Next i
    If Not deBloomValid Then
        Exit Sub
    End If
    highValue = 0
    DoEvents
    For i = 0 To 66000
        errMsg = "Finding peak of histogram at value " & i
        If myHistArray(i) > highValue Then
            highValue = myHistArray(i)
            highCount = i
        End If
        currentXValue = 5000 + (i / 10)
        currentYValue = myHistArray(i) / 10
        If Not deBloomValid Then
            Exit For
        End If
    Next i
    If Not deBloomValid Then
        Exit Sub
    End If
    highChangeRate = 0
    lowChangeRate = 0
    If highCount > 30000 Then
        highCount = Round(highCount / 3)
    End If
    errMsg = "Analyzing rate of change in histogram."
    For i = 0 To highCount * 2
        changeRate = myHistArray(i + 1) - myHistArray(i)
        If changeRate > highChangeRate Then
            highChangeRate = changeRate
            highChangeLocation = i
        End If
        If changeRate < lowChangeRate Then
            lowChangeRate = changeRate
            lowChangeLocation = i
        End If
        If Not deBloomValid Then
            Exit For
        End If
    Next i
    If Not deBloomValid Then
        Exit Sub
    End If
    If highChangeLocation > 500 Then
        myCtr = highChangeLocation - 500
    Else
        myCtr = 1
    End If
    frmBloomRemoval.Width = 13260
    DoEvents
    Label1.Caption = "Highest rate of increase occurs at " & highChangeLocation & "; highest rate of decrease occurs at " & lowChangeLocation
    errMsg = "Plotting histogram data: dim portion of histogram."
    For i = myCtr To (highCount + ((highCount - myCtr) * 1.5))
        If ((highCount + ((highCount - myCtr) * 1.5)) - myCtr) = 0 Then
            Err.Raise 2, "fixAllBlooms", "The following calculation would result in division by zero: ((highCount + ((highCount - myCtr) * 1.5)) - myCtr)"
        End If
        currentXValue = 5000 + (8000 / ((highCount + ((highCount - myCtr) * 1.5)) - myCtr)) * (i - myCtr)
        currentYValue = 4000 - (myHistArray(i) / 6)
        Line (currentXValue, 5000)-(currentXValue, currentYValue), RGB(128, 128, 255)
        DoEvents
    Next i
    Me.DrawMode = 10
    errMsg = "Plotting histogram data: rate of change."
    For i = myCtr To (highCount + ((highCount - myCtr) * 1.5))
        If ((highCount + ((highCount - myCtr) * 1.5)) - myCtr) = 0 Then
            Err.Raise 2, "fixAllBlooms", "The following calculation would result in division by zero: ((highCount + ((highCount - myCtr) * 1.5)) - myCtr)"
        End If
        currentXValue = 5000 + (8000 / ((highCount + ((highCount - myCtr) * 1.5)) - myCtr)) * (i - myCtr)
        changeRate = myHistArray(i + 1) - myHistArray(i)
        currentYValue = 4000 - (changeRate * 4)
        Line (currentXValue, 5000)-(currentXValue, currentYValue), RGB(255, 0, 0)
        DoEvents
    Next i
    Me.DrawMode = 13
    frmBloomRemoval.txtMsg.Text = frmBloomRemoval.txtMsg.Text & "Highest rate of increase occurs at " & highChangeLocation & "; this is assumed to be background level." & vbCrLf
    frmBloomRemoval.txtMsg.Text = frmBloomRemoval.txtMsg.Text & "Suggested star limit is background + " & frmOptions.txtStarAdjust & " = " & highChangeLocation + CDbl(frmOptions.txtStarAdjust)
    frmBloomRemoval.txtMsg.SelStart = Len(frmBloomRemoval.txtMsg.Text)
    DoEvents
    On Error GoTo 0
    Exit Sub
    
errHandler:
  errMsg = "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Additional information: " & errMsg
  MsgBox errMsg
  Exit Sub
End Sub

Private Sub Command6_Click()
    Label1.Caption = ""
    frmBloomRemoval.Width = 4995
End Sub

Private Sub Form_Load()
    Dim ver_major, ver_minor, ver_revision, verVersion, myDays
    
    'autoRegister = True
    SetWindowPos Me.hWnd, HWND_TOPMOST, 0, 0, 0, 0, (SWP_NOMOVE + SWP_NOSIZE)
    DoEvents
    frmBloomRemoval.progressBar.Visible = False
    frmBloomRemoval.progressBar.X2 = frmBloomRemoval.progressBar.X1
    ver_major = App.Major
    ver_minor = App.Minor
    ver_revision = App.Revision
    verVersion = ver_major & "." & ver_minor & "." & ver_revision
    lblVersion.Caption = "Version " & verVersion
    getSettings
    DoEvents
    myBackgroundAvg = -1
    rotateZoom = 2
    frmRotate.Picture1.Height = rotateZoom * 60
    frmRotate.Picture1.Width = rotateZoom * 60
End Sub

Private Sub Image1_Click()
    ShowWebpage "http://www.newastro.com/"
End Sub

Public Sub Label14_Click()
    On Error GoTo errHandler
    ' Find max pixel values.
    Dim myArray, ulimitX, uLimitY, i, j, maxPixel, tmpValue
    
    On Error GoTo errHandler
    tmpValue = frmBloomRemoval.txtStarLimit.Text
    deBloomValid = True
    frmBloomRemoval.Command1.Enabled = False
    frmBloomRemoval.Command4.Enabled = False
    frmBloomRemoval.lblMsg.Caption = "Calculating bloom limit..."
    DoEvents
    errMsg = "Getting document from MaxIm DL."
    myArray = myDoc.ImageArray
    ulimitX = UBound(myArray, 1)
    uLimitY = UBound(myArray, 2)
    maxPixel = 1
    For i = 0 To uLimitY
        errMsg = "Scanning image to calculate suggested bloom limit."
        If Not deBloomValid Then
            Exit For
        End If
        For j = 0 To ulimitX
            If myArray(j, i) > maxPixel Then
                maxPixel = myArray(j, i)
            End If
        Next j
        DoEvents
    Next i
    frmBloomRemoval.Command1.Enabled = True
    frmBloomRemoval.Command4.Enabled = True
    If Not deBloomValid Then
        frmBloomRemoval.txtBloomLimit.Text = tmpValue
        Exit Sub
    End If
    If maxPixel < CLng(frmBloomRemoval.txtStarLimit.Text) Then
        frmBloomRemoval.txtBloomLimit.Text = CLng(frmBloomRemoval.txtStarLimit.Text) + 1001
    Else
        frmBloomRemoval.txtBloomLimit.Text = Round(maxPixel * 0.75)
    End If
    On Error GoTo 0
    frmBloomRemoval.lblMsg.Caption = ""
    Exit Sub
    
errHandler:
    errMsg = "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Additional information: " & errMsg
    MsgBox errMsg
    frmBloomRemoval.lblMsg.Caption = ""
    Exit Sub

End Sub

Public Sub Label17_Click()
    ' Calculate suggested star limit.
    Dim myArray, ulimitX, uLimitY, myAdder As Double, i, j, tmpValue, highCount, changeRate
    Dim myBackgroundTotal, myBackgroundCtr, highValue, retValue, currentXValue, currentYValue
    Dim myHistArray(66000), highChangeRate, lowChangeRate, myCtr, highChangeLocation, lowChangeLocation
    
    On Error GoTo errHandler
    tmpValue = frmBloomRemoval.txtStarLimit.Text
    deBloomValid = True
    frmBloomRemoval.Command1.Enabled = False
    frmBloomRemoval.Command4.Enabled = False
    frmBloomRemoval.lblMsg.Caption = "Calculating star limit..."
    DoEvents
    errMsg = "Getting document from MaxIm DL."
    myArray = myDoc.ImageArray
    ulimitX = UBound(myArray, 1)
    uLimitY = UBound(myArray, 2)
    ' Scan and create histogram.
    On Error GoTo 0
    For i = 0 To uLimitY Step 1
        errMsg = "Scanning image to build histogram."
        If Not deBloomValid Then
            Exit For
        End If
        For j = 0 To ulimitX Step 1
            If myArray(j, i) < UBound(myHistArray) Then
                myHistArray(myArray(j, i)) = myHistArray(myArray(j, i)) + 1
            End If
            'myHistArray(myArray(j, i)) = myHistArray(myArray(j, i)) + 1
        Next j
        DoEvents
    Next i
    highChangeRate = 0
    lowChangeRate = 0
    errMsg = "Scanning for rate of change"
    For i = 0 To 30000
        changeRate = myHistArray(i + 1) - myHistArray(i)
        If changeRate > highChangeRate Then
            highChangeRate = changeRate
            highChangeLocation = i
        End If
    Next i
    frmBloomRemoval.Command1.Enabled = True
    frmBloomRemoval.Command4.Enabled = True
    If Not deBloomValid Then
        frmBloomRemoval.txtStarLimit.Text = tmpValue
        Exit Sub
    End If
    frmBloomRemoval.txtStarLimit.Text = Round(highChangeLocation + frmOptions.txtStarAdjust)
    myBackgroundAvg = highChangeLocation
    On Error GoTo 0
    frmBloomRemoval.lblMsg.Caption = ""
    Exit Sub
    
errHandler:
    errMsg = "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Additional information: " & errMsg
    MsgBox errMsg
    frmBloomRemoval.lblMsg.Caption = ""
    Exit Sub
End Sub

Private Sub Label20_Click()
    ShowWebpage "http://www.NewAstro.com/"
End Sub
