VERSION 5.00
Begin VB.Form frmUI 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "New Astronomy Gradient Remover"
   ClientHeight    =   6915
   ClientLeft      =   150
   ClientTop       =   720
   ClientWidth     =   3870
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6915
   ScaleWidth      =   3870
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command6 
      Caption         =   ">"
      Height          =   315
      Left            =   3420
      TabIndex        =   36
      Top             =   1080
      Width           =   315
   End
   Begin VB.CheckBox chkDoAll 
      Caption         =   "All open images"
      Height          =   255
      Left            =   2220
      TabIndex        =   35
      Top             =   3540
      Value           =   1  'Checked
      Width           =   1515
   End
   Begin VB.CheckBox chkReverse 
      Caption         =   "Reverse (add)"
      Height          =   255
      Left            =   120
      TabIndex        =   34
      Top             =   3540
      Width           =   1515
   End
   Begin VB.Frame Frame2 
      Caption         =   "Descpeckling"
      Height          =   1515
      Left            =   120
      TabIndex        =   25
      Top             =   5280
      Width           =   3615
      Begin VB.CommandButton Command5 
         Caption         =   "Despeckle"
         Height          =   375
         Left            =   2400
         TabIndex        =   28
         Top             =   240
         Width           =   1035
      End
      Begin VB.TextBox txtStrength 
         Height          =   285
         Left            =   960
         TabIndex        =   27
         Text            =   "500"
         Top             =   780
         Width           =   675
      End
      Begin VB.TextBox txtSigma 
         Height          =   285
         Left            =   960
         TabIndex        =   26
         Text            =   "2.4"
         Top             =   300
         Width           =   675
      End
      Begin VB.Label Label14 
         Caption         =   "Note: Lower numbers intensify the effect."
         Height          =   255
         Left            =   240
         TabIndex        =   33
         Top             =   1200
         Width           =   3195
      End
      Begin VB.Label Label13 
         Caption         =   "100-5000"
         Height          =   255
         Left            =   1740
         TabIndex        =   32
         Top             =   780
         Width           =   795
      End
      Begin VB.Label Label12 
         Caption         =   "1-3"
         Height          =   255
         Left            =   1740
         TabIndex        =   31
         Top             =   300
         Width           =   435
      End
      Begin VB.Label Label11 
         Alignment       =   1  'Right Justify
         Caption         =   "Strength"
         Height          =   255
         Left            =   120
         TabIndex        =   30
         Top             =   840
         Width           =   735
      End
      Begin VB.Label Label10 
         Alignment       =   1  'Right Justify
         Caption         =   "Sigma"
         Height          =   255
         Left            =   120
         TabIndex        =   29
         Top             =   300
         Width           =   735
      End
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Undo All"
      Height          =   255
      Left            =   1320
      TabIndex        =   13
      Top             =   4800
      Width           =   1155
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Undo Last"
      Height          =   255
      Left            =   1320
      TabIndex        =   12
      Top             =   4500
      Width           =   1155
   End
   Begin VB.TextBox txtAngle 
      Height          =   315
      Left            =   1920
      TabIndex        =   6
      Text            =   "45"
      Top             =   1080
      Width           =   1455
   End
   Begin VB.Frame Frame1 
      Caption         =   "Gradient options"
      Height          =   1395
      Left            =   120
      TabIndex        =   4
      Top             =   2040
      Width           =   3615
      Begin VB.CheckBox chkFlipH 
         Caption         =   "Flip horizontal"
         Height          =   255
         Left            =   180
         TabIndex        =   24
         Top             =   1500
         Visible         =   0   'False
         Width           =   1515
      End
      Begin VB.CheckBox chkFlipV 
         Caption         =   "Flip vertical"
         Height          =   255
         Left            =   2100
         TabIndex        =   23
         Top             =   1560
         Visible         =   0   'False
         Width           =   1215
      End
      Begin VB.TextBox txtIntensity 
         Height          =   255
         Left            =   1140
         TabIndex        =   21
         Text            =   "1"
         ToolTipText     =   "Values of 1-2.5 are appropriate"
         Top             =   360
         Width           =   435
      End
      Begin VB.Frame frmRadialSettings 
         Caption         =   "Radial Origin"
         Height          =   1035
         Left            =   2100
         TabIndex        =   15
         Top             =   180
         Width           =   1395
         Begin VB.TextBox txtY 
            Height          =   285
            Left            =   420
            TabIndex        =   19
            Text            =   "0"
            Top             =   600
            Width           =   795
         End
         Begin VB.TextBox txtX 
            Height          =   285
            Left            =   420
            TabIndex        =   18
            Text            =   "0"
            Top             =   300
            Width           =   795
         End
         Begin VB.Label Label7 
            Caption         =   "Y"
            Height          =   195
            Left            =   120
            TabIndex        =   17
            Top             =   660
            Width           =   195
         End
         Begin VB.Label Label6 
            Caption         =   "X"
            Height          =   195
            Left            =   120
            TabIndex        =   16
            Top             =   360
            Width           =   195
         End
      End
      Begin VB.OptionButton optRadial 
         Caption         =   "Radial"
         Height          =   255
         Left            =   1140
         TabIndex        =   14
         Top             =   900
         Width           =   855
      End
      Begin VB.OptionButton optLinear 
         Caption         =   "Linear"
         Height          =   255
         Left            =   180
         TabIndex        =   5
         Top             =   900
         Value           =   -1  'True
         Width           =   855
      End
      Begin VB.Label Label8 
         Alignment       =   1  'Right Justify
         Caption         =   "Intensity"
         Height          =   255
         Left            =   240
         TabIndex        =   22
         Top             =   360
         Width           =   735
      End
   End
   Begin VB.CommandButton Command2 
      Cancel          =   -1  'True
      Caption         =   "Done"
      Height          =   555
      Left            =   120
      TabIndex        =   3
      Top             =   4500
      Width           =   975
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Remove Gradient"
      Default         =   -1  'True
      Height          =   555
      Left            =   2760
      TabIndex        =   2
      Top             =   4500
      Width           =   975
   End
   Begin VB.TextBox txtHorizontal 
      Height          =   315
      Left            =   1920
      TabIndex        =   0
      Text            =   "400"
      Top             =   660
      Width           =   1455
   End
   Begin VB.Label Label9 
      Alignment       =   2  'Center
      BackColor       =   &H00C0FFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Click here to learn about DeBloomer"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000000&
      Height          =   315
      Left            =   120
      MouseIcon       =   "frmUI.frx":0000
      MousePointer    =   99  'Custom
      TabIndex        =   20
      Top             =   6900
      Width           =   3615
   End
   Begin VB.Label lblStatus 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Status"
      Height          =   315
      Left            =   120
      TabIndex        =   11
      Top             =   3960
      Width           =   3615
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "http://www.newastro.com"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   120
      MouseIcon       =   "frmUI.frx":030A
      MousePointer    =   99  'Custom
      TabIndex        =   10
      Top             =   240
      Width           =   3315
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   " New Astronomy Press"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      MouseIcon       =   "frmUI.frx":0614
      MousePointer    =   99  'Custom
      TabIndex        =   9
      Top             =   0
      Width           =   3315
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "Angle: Bright at 9 o'clock = 0; at 12 o'clock = 90; at 3 o'clock = 180; at 6 o'clock = 270, etc."
      Height          =   375
      Left            =   120
      TabIndex        =   8
      Top             =   1560
      Width           =   3615
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Gradient angle"
      Height          =   255
      Left            =   420
      TabIndex        =   7
      Top             =   1080
      Width           =   1335
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Gradient amount"
      Height          =   255
      Left            =   300
      TabIndex        =   1
      Top             =   720
      Width           =   1455
   End
   Begin VB.Menu help_menu 
      Caption         =   "Web Help"
   End
End
Attribute VB_Name = "frmUI"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Sample Plug-in for removaing a gradient.
' Copyright 2002 by Ron Wodaski.
' http://www.newastro.com
' Code may be repurposed without permission. Use this sample to build your own plug-ins.

Option Explicit


Private Sub Command1_Click()
    errMsg = "Remove gradient button on frmUI."
    Dim aperture, origin
    
    On Error GoTo errHandler
    If frmUI.optRadial Then
        If Not IsNumeric(frmUI.txtIntensity.Text) Then
            MsgBox "Invalid Aperture value (non-numeric). Cannot proceed."
            Exit Sub
        End If
        aperture = CDbl(frmUI.txtIntensity.Text)
        If aperture < 0.5 Or aperture > 5 Then
            MsgBox "Invalid Aperture value (smaller than 0.5, or larger than 5). Cannot proceed."
            Exit Sub
        End If
        ' Check origin.
        If Not IsNumeric(frmUI.txtX.Text) Then
            MsgBox "Invalid X origin value (non-numeric). Cannot proceed."
            Exit Sub
        End If
        If Not IsNumeric(frmUI.txtY.Text) Then
            MsgBox "Invalid Y origin value (non-numeric). Cannot proceed."
            Exit Sub
        End If
        origin = CDbl(frmUI.txtX.Text)
        If origin < 0 Or origin > imgWidth Then
            MsgBox "Invalid X origin value (less than zero, or larger than image width of " & imgWidth & "). Cannot proceed."
            Exit Sub
        End If
        origin = CDbl(frmUI.txtY.Text)
        If origin < 0 Or origin > imgHeight Then
            MsgBox "Invalid Y origin value (less than zero, or larger than image height of " & imgHeight & "). Cannot proceed."
            Exit Sub
        End If
    Else
        If Not IsNumeric(frmUI.txtAngle.Text) Then
            MsgBox "Error: the gradient angle must be numeric."
            Exit Sub
        End If
        If CDbl(frmUI.txtAngle.Text) < 0 Or CDbl(frmUI.txtAngle.Text) > 359 Then
            MsgBox "Error: the gradient angle must be between 0 and 359 degrees, inclusive."
            Exit Sub
        End If
    End If
    If Not IsNumeric(frmUI.txtHorizontal.Text) Then
        MsgBox "Error: the Gradient amount must be numeric."
        Exit Sub
    End If
    If CDbl(frmUI.txtHorizontal.Text) <= 1 Or CDbl(frmUI.txtHorizontal.Text) > 9999 Then
        MsgBox "Error: the gradient amount must be between 1 and 10000."
        Exit Sub
    End If
    ' Save Settings to registry.
    saveRegSettings
    ' Call sub that removes gradient.
    remGradient
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Command2_Click()
    Unload frmImage
    Unload Me
End Sub

Private Sub Command3_Click()
    errMsg = "Undo Last"
    On Error GoTo errHandler
    myImgArray = myTempArray
    saveOK = True
    If isMaxIm Then
        frmUI.lblStatus = "Undo Last (MaxIm DL)"
        DoEvents
        MaxImSave
    Else
        frmUI.lblStatus = "Undo Last (CCDSoft)"
        DoEvents
        CCDSoftSave
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Command4_Click()
    errMsg = "undo All"
    On Error GoTo errHandler
    myImgArray = myOrigArray
    saveOK = True
    If isMaxIm Then
        frmUI.lblStatus = "Undo All (MaxIm DL)"
        DoEvents
        MaxImSave
    Else
        frmUI.lblStatus = "Undo All (CCDSoft)"
        DoEvents
        CCDSoftSave
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Command5_Click()
    errMsg = "Despeckle button"
    Dim intensity, spread
    
    On Error GoTo errHandler
    If Not IsNumeric(frmUI.txtSigma.Text) Or Not IsNumeric(frmUI.txtStrength.Text) Then
        MsgBox "Invalid Sigma/Strength. Cannot continue."
        Exit Sub
    End If
    intensity = CDbl(frmUI.txtSigma.Text)
    If intensity < 1.5 Or intensity > 3 Then
        intensity = 2
    End If
    spread = CInt(frmUI.txtStrength.Text)
    If spread < 100 Or spread > 5000 Then
        spread = 500
    End If
    cleanImage intensity, spread
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Command6_Click()
    On Error GoTo errHandler
    abortPaintImage = False
    errMsg = "Display frmImage button on frmUI"
    frmImage.optLinear.Value = frmUI.optLinear.Value
    frmImage.optRadial.Value = frmUI.optRadial.Value
    frmImage.cmdCancel.Enabled = False
    frmImage.cmdDone.Enabled = False
    frmImage.Show 1
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Form_Load()
    On Error GoTo errHandler
    errMsg = "Loading frmUI"
    getRegSettings
    errMsg = "After getting Registry settings."
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Form_Unload(Cancel As Integer)
    ' Save Settings to registry.
    saveRegSettings
    Unload frmImage
End Sub

Private Sub help_menu_Click()
    On Error GoTo errHandler
    If registeredUser Then
        ShowWebpage "http://www.newastro.com/newastro/downloads/rem_grad/help.htm"
    Else
        ShowWebpage "http://www.newastro.com/newastro/downloads/rem_grad/default.htm"
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub

Private Sub Label4_Click()
    ShowWebpage "http://www.newastro.com/"
End Sub

Private Sub Label5_Click()
    ShowWebpage "http://www.newastro.com/"
End Sub

Private Sub Label9_Click()
    ShowWebpage "http://www.newastro.com/newastro/downloads/debloom/default.htm"
End Sub

Public Sub optLinear_Click()
    setEnableds
End Sub

Private Sub optRadial_Click()
    setEnableds
End Sub

Public Sub setEnableds()
    On Error GoTo errHandler
    errMsg = "setEnabled() on frmUI"
    If frmUI.optRadial.Value Then
        frmUI.txtAngle.Enabled = False
        frmUI.frmRadialSettings.Enabled = True
    Else
        frmUI.txtAngle.Enabled = True
        frmUI.frmRadialSettings.Enabled = False
    End If
    Exit Sub
errHandler:
    MsgBox "Error #" & Err.Number & ": " & Err.Description & vbCrLf & "Context: " & errMsg
    Exit Sub
End Sub
